package w83b.ejie.general.filters;

import java.io.IOException;

import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang.StringUtils;
import org.apache.struts.action.DynaActionForm;

import w83b.w83bBeans.W83bBaseBean;
import w83b.w83bBeans.W83bUsuarioXLNetsBean;
import w83b.w83bUtilidades.W83bUtilidadesComunes;
import w83b.w83bUtilidadesComunes.W83bClsConstantes;
import es.ejie.frmk.presentacion.sesiondatos.Q70ContextoEJIE;

public class W83bEnterEncodingFilter
  implements Filter
{
  private String encoding = "utf-8";

  public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException
  {
	HttpServletRequest httpRequest =  (HttpServletRequest)request;
	request.setCharacterEncoding(this.encoding);
	

    
    Q70ContextoEJIE contexto = (Q70ContextoEJIE)httpRequest.getSession().getAttribute("contexto");
    
    if(null!=contexto){
	    String mensaje = (String)contexto.get(W83bClsConstantes.CONSTANTE_MENSAJES_APLICACION_NO_ERROR);
	    
	    if(StringUtils.isNotEmpty(mensaje)){
	    	contexto.set(W83bClsConstantes.CONSTANTE_MENSAJES_APLICACION_NO_ERROR,null);
	    	
	    	W83bUtilidadesComunes.anyadirMensajeAplicacion(httpRequest,mensaje,(String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA));
	    }
	    try{
	    	 String listaBeansAInyectarUserStr = (String)contexto.get("inyectarUsuarioEnBean");
		    W83bUsuarioXLNetsBean usuarioBean = (W83bUsuarioXLNetsBean)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_USUARIO);
		    String strIdioma = (String)contexto.get(W83bClsConstantes.CONSTANTE_CONTEXTO_IDIOMA);
		    String[] listaBeansAInyectarUser = listaBeansAInyectarUserStr.split(",");
		    for(int i=0,size=listaBeansAInyectarUser.length;i<size;i++){
		    	if(-1!=listaBeansAInyectarUser[i].indexOf("[")){
			    	String formulario = listaBeansAInyectarUser[i].substring(0,listaBeansAInyectarUser[i].indexOf("["));
			    	String bean = listaBeansAInyectarUser[i].substring(listaBeansAInyectarUser[i].indexOf("[")+1,listaBeansAInyectarUser[i].length()-1);
			    	W83bBaseBean beanBase = (W83bBaseBean)contexto.get(bean);
			    	beanBase.setIdioma(strIdioma);
			    	beanBase.setUsuarioBean(usuarioBean);
			    	contexto.set(bean,beanBase);
			    	DynaActionForm formu = (DynaActionForm)httpRequest.getSession().getAttribute(formulario);
			    	if(null!=formu){
			    		formu.set(bean, beanBase);
			    		request.setAttribute(formulario, formu);
			    	}
		    	}else{
		    		String bean = listaBeansAInyectarUser[i];
			    	W83bBaseBean beanBase = (W83bBaseBean)contexto.get(bean);
			    	beanBase.setIdioma(strIdioma);
			    	beanBase.setUsuarioBean(usuarioBean);
			    	contexto.set(bean,beanBase);
		    	}
		    }
	    }catch (Exception e) {
			// TODO: handle exception
	    	//e.printStackTrace();
		}
    }
    chain.doFilter(new W83bFilteredRequest(request), response);
  }
  

  public void init(FilterConfig filterConfig) throws ServletException {
    String encodingParam = filterConfig.getInitParameter("encoding");
    if (encodingParam != null)
      this.encoding = encodingParam;
  }

  public void destroy()
  {
  }
}
